<?php
include ("../serive/samparka.php");

// Sanitize and format amount
$ramt = isset($_GET['amount']) ? htmlspecialchars(mysqli_real_escape_string($conn, $_GET['amount'])) : '0';
$dot_pos = strpos($ramt, '.');
if ($dot_pos === false) {
    $ramt = $ramt . '.00';
} else {
    $after_dot = substr($ramt, $dot_pos + 1);
    $after_dot_length = strlen($after_dot);
    if ($after_dot_length > 2) {
        $after_dot = substr($after_dot, 0, 2);
        $ramt = substr($ramt, 0, $dot_pos + 1) . $after_dot;
    } elseif ($after_dot_length < 2) {
        $zeros_to_add = 2 - $after_dot_length;
        $ramt = $ramt . str_repeat('0', $zeros_to_add);
    }
}

$serial = 'P' . date("Ymd") . time() . rand(1000,9999);

// Get UPI details
$s_upi = "SELECT maulya FROM deyya WHERE sthiti='1'";
$f_upi = mysqli_fetch_array(mysqli_query($conn, $s_upi));
$upi_id = $f_upi['maulya'] ?? 'upi@example.com';

$qr_result = mysqli_fetch_array(mysqli_query($conn, "SELECT * FROM `images` WHERE `status`=1"));
$qr_code_image_path = '../images/'.$qr_result['filename'] ?? 'default_qr.png';

// Security validation
$valid = true;
if (isset($_GET['tyid']) && isset($_GET['uid']) && isset($_GET['sign']) && isset($_GET['urlInfo'])) {
    $tyid = htmlspecialchars(mysqli_real_escape_string($conn, $_GET['tyid']));
    $uid = htmlspecialchars(mysqli_real_escape_string($conn, $_GET['uid']));
    $sign = htmlspecialchars(mysqli_real_escape_string($conn, $_GET['sign']));
    $urlInfo = htmlspecialchars(mysqli_real_escape_string($conn, $_GET['urlInfo']));
    
    // User verification
    $numquery = "SELECT mobile, codechorkamukala FROM shonu_subjects WHERE id = ".$uid;
    $numresult = $conn->query($numquery);
    $numarr = mysqli_fetch_array($numresult);
    
    $userName = '91'.$numarr['mobile'];
    $nickName = $numarr['codechorkamukala'];
    
    $creaquery = "SELECT createdate FROM shonu_subjects WHERE id = ".$uid;
    $crearesult = $conn->query($creaquery);
    $creaarr = mysqli_fetch_array($crearesult);
    
    $knbdstr = '{"userId":'.$uid.',"userPhoto":"1","userName":'.$userName.',"nickName":"'.$nickName.'","createdate":"'.$creaarr['createdate'].'"}';
    $shonusign = strtoupper(hash('sha256', $knbdstr));
    
    $urlarr = explode(",", $urlInfo);
    $theirurl = $urlarr[0];
    $myurl = 'https://91xwin.site';
    
    $valid = ($shonusign == $sign && $theirurl == $myurl);
}

if($valid) {
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>UPI Payment | ₹<?php echo $ramt; ?></title>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/clipboard.js/2.0.11/clipboard.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Nunito+Sans:wght@300;400;600&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary: #5a67d8;
            --primary-light: #c3dafe;
            --primary-lighter: #ebf4ff;
            --danger: #e53e3e;
            --success: #38a169;
            --warning: #dd6b20;
            --bg: #f7fafc;
            --card: #ffffff;
            --text: #2d3748;
            --text-light: #718096;
            --text-lighter: #a0aec0;
            --border: #e2e8f0;
            --radius: 12px;
            --shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
            --transition: all 0.2s ease-in-out;
        }

        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
            font-family: 'Nunito Sans', sans-serif;
            font-weight: 300;
        }

        body {
            background: var(--bg);
            color: var(--text);
            line-height: 1.6;
            padding: 5px;
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .payment-container {
            width: 100%;
            max-width: 400px;
            position: relative;
        }

        .payment-card {
            background: var(--card);
            border-radius: var(--radius);
            box-shadow: var(--shadow);
            overflow: hidden;
            transition: var(--transition);
            margin-bottom: 20px;
        }

        .payment-header {
            background: var(--primary);
            color: white;
            padding: 24px;
            text-align: center;
            position: relative;
        }

        .payment-header h1 {
            font-size: 22px;
            font-weight: 300;
            margin-bottom: 8px;
            letter-spacing: 0.5px;
        }

        .payment-header p {
            font-size: 14px;
            opacity: 0.9;
            font-weight: 300;
        }

        .payment-body {
            padding: 24px;
        }

        .payment-amount {
            text-align: center;
            margin-bottom: 24px;
        }

        .payment-amount-value {
            font-size: 36px;
            font-weight: 300;
            color: var(--primary);
            margin-bottom: 8px;
            letter-spacing: 1px;
        }

        .payment-amount-label {
            font-size: 14px;
            color: var(--text-light);
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 8px;
            font-weight: 300;
        }

        .payment-timer {
            background: var(--primary-light);
            color: var(--primary);
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 13px;
            font-weight: 400;
            display: inline-flex;
            align-items: center;
            gap: 6px;
        }

        .payment-methods {
            display: flex;
            gap: 8px;
            margin: 20px 0;
            border-bottom: 1px solid var(--border);
            padding-bottom: 16px;
        }

        .payment-method {
            flex: 1;
            text-align: center;
            padding: 12px;
            border-radius: 6px;
            background: transparent;
            font-size: 14px;
            font-weight: 400;
            cursor: pointer;
            color: var(--text-light);
            border: none;
            transition: var(--transition);
            position: relative;
        }

        .payment-method.active {
            color: var(--primary);
        }

        .payment-method.active:after {
            content: '';
            position: absolute;
            bottom: -17px;
            left: 0;
            width: 100%;
            height: 2px;
            background: var(--primary);
        }

        .payment-section {
            display: none;
            animation: fadeIn 0.3s ease-out;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(8px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .payment-section.active {
            display: block;
        }

        .upi-box {
            background: var(--primary-lighter);
            border-radius: var(--radius);
            padding: 10px;
            margin-bottom: 12px;
            display: flex;
            align-items: center;
            border: 1px solid var(--border);
            gap: 12px;
            transition: var(--transition);
        }

        .upi-id {
            flex: 1;
            font-size: 16px;
            word-break: break-all;
            color: var(--primary);
            font-weight: 400;
        }

        .copy-icon {
            color: var(--primary);
            font-size: 18px;
            cursor: pointer;
            padding: 8px;
            border-radius: 50%;
            transition: var(--transition);
        }

        .copy-icon:hover {
            background: rgba(90, 103, 216, 0.1);
        }

        .copy-icon.copied {
            color: var(--success);
        }

        .qr-container {
            text-align: center;
            margin-bottom: 20px;
        }

        .qr-code {
            width: 200px;
            height: 200px;
            margin: 0 auto 16px;
            border: 1px solid var(--border);
            border-radius: var(--radius);
            padding: 16px;
            background: white;
            box-shadow: var(--shadow);
        }

        .qr-code img {
            width: 100%;
            height: 100%;
            object-fit: contain;
        }

        .qr-note {
            font-size: 14px;
            color: var(--text-light);
            font-weight: 300;
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-label {
            display: block;
            font-size: 14px;
            margin-bottom: 8px;
            color: var(--text);
            font-weight: 400;
        }

        .form-input {
            width: 100%;
            padding: 14px 16px;
            border: 1px solid var(--border);
            border-radius: var(--radius);
            font-size: 16px;
            background: white;
            transition: var(--transition);
            font-weight: 300;
        }

        .form-input:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(90, 103, 216, 0.1);
        }

        .form-input::placeholder {
            color: var(--text-lighter);
            font-weight: 300;
        }

        .btn {
            display: inline-block;
            padding: 14px;
            background: var(--primary);
            color: white;
            border: none;
            border-radius: var(--radius);
            font-size: 16px;
            font-weight: 400;
            cursor: pointer;
            text-align: center;
            transition: var(--transition);
            width: 100%;
            box-shadow: var(--shadow);
        }

        .btn:hover {
            background: #4c51bf;
            transform: translateY(-1px);
        }

        .btn:active {
            transform: translateY(0);
        }

        .btn:disabled {
            background: var(--text-lighter);
            cursor: not-allowed;
            transform: none;
            box-shadow: none;
        }

        .payment-logos {
            display: flex;
            justify-content: center;
            gap: 24px;
            margin-top: 24px;
            opacity: 0.7;
        }

        .payment-logos img {
            height: 24px;
        }

        .upi-apps {
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
            gap: 12px;
            margin: 20px 0;
        }

        .upi-app {
            width: 60px;
            height: 60px;
            border-radius: 12px;
            background: white;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: var(--shadow);
            cursor: pointer;
            transition: var(--transition);
            overflow: hidden;
        }

        .upi-app:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
        }

        .upi-app img {
            width: 80%;
            height: 80%;
            object-fit: contain;
        }

        .upi-apps-title {
            text-align: center;
            font-size: 14px;
            color: var(--text-light);
            margin-bottom: 12px;
            font-weight: 300;
        }

        .verification-popup-overlay {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0,0,0,0.5);
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 1000;
            opacity: 0;
            visibility: hidden;
            transition: var(--transition);
            backdrop-filter: blur(4px);
        }

        .verification-popup-overlay.active {
            opacity: 1;
            visibility: visible;
        }

        .verification-popup {
            background: white;
            border-radius: var(--radius);
            width: 90%;
            max-width: 400px;
            overflow: hidden;
            transform: translateY(10px);
            transition: var(--transition);
            box-shadow: var(--shadow);
        }

        .verification-popup-overlay.active .verification-popup {
            transform: translateY(0);
        }

        .popup-header {
            background: var(--primary);
            color: white;
            padding: 20px;
            text-align: center;
            position: relative;
        }

        .popup-header i {
            font-size: 40px;
            margin-bottom: 12px;
        }

        .popup-header h3 {
            font-weight: 300;
            margin: 0;
            font-size: 18px;
            letter-spacing: 0.5px;
        }

        .popup-body {
            padding: 20px;
        }

        .detail-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 16px;
            padding-bottom: 16px;
            border-bottom: 1px solid var(--border);
        }

        .detail-label {
            color: var(--text-light);
            font-weight: 300;
        }

        .detail-value {
            font-weight: 400;
            color: var(--text);
        }

        .popup-note {
            margin-top: 16px;
            font-size: 13px;
            color: var(--text-light);
            text-align: center;
            font-style: italic;
            line-height: 1.5;
            font-weight: 300;
        }

        .popup-footer {
            display: flex;
            border-top: 1px solid var(--border);
        }

        .popup-btn {
            flex: 1;
            padding: 14px;
            border: none;
            background: none;
            font-weight: 400;
            cursor: pointer;
            transition: var(--transition);
            font-size: 14px;
        }

        .popup-btn.cancel-btn {
            color: var(--text-light);
            border-right: 1px solid var(--border);
        }

        .popup-btn.cancel-btn:hover {
            background: #f5f5f5;
        }

        .popup-btn.confirm-btn {
            background: var(--primary);
            color: white;
        }

        .popup-btn.confirm-btn:hover {
            background: #4c51bf;
        }

        .loading-overlay {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(255,255,255,0.8);
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 1000;
            opacity: 0;
            visibility: hidden;
            transition: var(--transition);
        }

        .loading-overlay.active {
            opacity: 1;
            visibility: visible;
        }

        .loading-content {
            text-align: center;
            font-size: 14px;
            color: var(--text-light);
            font-weight: 300;
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 12px;
        }

        .loading-content i {
            font-size: 48px;
            color: var(--primary);
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        @media (max-width: 480px) {
            .payment-header {
                padding: 20px;
            }
            
            .payment-body {
                padding: 20px;
            }
            
            .payment-amount-value {
                font-size: 32px;
            }
            
            .upi-app {
                width: 54px;
                height: 54px;
            }
            
            .verification-popup {
                width: 95%;
            }
        }
    </style>
</head>
<body>
    <div class="payment-container">
        <div class="payment-card">
            <div class="payment-body">
                <div class="payment-amount">
                    <div class="payment-amount-value">₹<?php echo $ramt; ?></div>
                    <div class="payment-amount-label">
                        Amount to pay
                        <span class="payment-timer">
                            <i class="fas fa-clock"></i>
                            <span id="countdown">05:00</span>
                        </span>
                    </div>
                </div>
                
                <div class="payment-methods">
                    <button class="payment-method active" data-target="upi-section">
                        <i class="fas fa-mobile-alt"></i> UPI Pay
                    </button>
                    <button class="payment-method" data-target="qr-section">
                        <i class="fas fa-qrcode"></i> QR Code
                    </button>
                </div>
                
                <div class="payment-section active" id="upi-section">
                    <div class="upi-box">
                        <div class="upi-id" id="upi-id"><?php echo $upi_id; ?></div>
                        <i class="fas fa-copy copy-icon" id="copy-icon"></i>
                    </div>
                    
                    <div class="upi-box">
                        <div class="upi-id" id="upi-id">₹<?php echo $ramt; ?></div>
                        <i class="fas fa-copy copy-icon" id="copy-icon"></i>
                    </div>

                    <div class="upi-apps-title">Pay with UPI Apps</div>
                    <div class="upi-apps">
                        <div class="upi-app" data-app="gpay">
                            <img src="https://uxwing.com/wp-content/themes/uxwing/download/brands-and-social-media/google-pay-icon.png" alt="Google Pay">
                        </div>
                        <div class="upi-app" data-app="phonepe">
                            <img src="https://raw.githubusercontent.com/hdpngworld/HPW/main/uploads/6509eac5314fe-logo.png" alt="PhonePe">
                        </div>
                        <div class="upi-app" data-app="paytm">
                            <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/4/42/Paytm_logo.png/640px-Paytm_logo.png" alt="Paytm">
                        </div>
                        <div class="upi-app" data-app="bhim">
                            <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/9/90/Bhim-logo.png/640px-Bhim-logo.png" alt="BHIM">
                        </div>
                    </div>
                </div>
                
                <div class="payment-section" id="qr-section">
                    <div class="qr-container">
                        <div class="qr-code">
                            <img src="<?php echo $qr_code_image_path; ?>" alt="UPI QR Code">
                        </div>
                        <p class="qr-note">
                            <i class="fas fa-info-circle"></i> 
                            Scan this QR code with any UPI app to pay ₹<?php echo $ramt; ?>
                        </p>
                    </div>
                </div>
                
                <div class="form-group">
                    <label class="form-label">
                        <i class="fas fa-receipt"></i> 
                        UTR/Reference Number
                    </label>
                    <input type="text" class="form-input" id="utr-input" placeholder="Enter 12-digit UTR" maxlength="12" inputmode="numeric">
                </div>
                
                <button class="btn" id="submit-btn" disabled>
                    <i class="fas fa-check-circle"></i> Verify Payment
                </button>
                
                <div class="payment-logos">
                    <img src="https://upload.wikimedia.org/wikipedia/commons/e/e1/UPI-Logo-vector.svg" alt="UPI Logo">
                    <img src="https://upload.wikimedia.org/wikipedia/commons/9/90/Bhim-logo.png" alt="BHIM Logo">
                </div>
            </div>
        </div>
    </div>

    <!-- Loading overlay (centered on screen) -->
    <div class="loading-overlay" id="loading-overlay">
        <div class="loading-content">
            <i class="fas fa-spinner"></i>
            <div>Verifying payment...</div>
        </div>
    </div>

    <script>
    $(document).ready(function() {
        // Initialize variables
        const ramt = <?php echo json_encode($ramt); ?>;
        const serial = <?php echo json_encode($serial); ?>;
        const upi = <?php echo json_encode($upi_id); ?>;
        const userId = <?php echo isset($uid) ? $uid : 0; ?>;
        const token = <?php echo isset($shonusign) ? json_encode($shonusign) : "''"; ?>;
        let countdownActive = true;
        
        // Tab switching
        $('.payment-method').click(function() {
            $('.payment-method').removeClass('active');
            $(this).addClass('active');
            $('.payment-section').removeClass('active');
            $('#' + $(this).data('target')).addClass('active');
        });
        
        // Copy UPI ID
        $('#copy-icon').click(function() {
            navigator.clipboard.writeText(upi).then(() => {
                $(this).addClass('copied');
                setTimeout(() => {
                    $(this).removeClass('copied');
                }, 2000);
            });
        });
        
        // UTR validation
        $('#utr-input').on('input', function() {
            const val = $(this).val().replace(/\D/g, '');
            $(this).val(val);
            $('#submit-btn').prop('disabled', val.length !== 12);
            
            if(val.length === 12) {
                showVerificationPopup(val);
            }
        });
        
        // Countdown timer
        function startTimer(duration, display) {
            let timer = duration, minutes, seconds;
            const interval = setInterval(() => {
                if(!countdownActive) {
                    clearInterval(interval);
                    return;
                }
                
                minutes = parseInt(timer / 60, 10);
                seconds = parseInt(timer % 60, 10);
                
                display.text(`${minutes.toString().padStart(2, '0')}:${seconds.toString().padStart(2, '0')}`);
                
                if (--timer < 0) {
                    clearInterval(interval);
                    display.text('00:00');
                    $('.payment-timer').html('<i class="fas fa-exclamation-circle"></i> Expired');
                    $('#utr-input, #submit-btn').prop('disabled', true);
                }
            }, 1000);
        }
        startTimer(300, $('#countdown'));
        
        // Show verification popup
        function showVerificationPopup(refNo) {
            const popup = $(`
            <div class="verification-popup-overlay">
                <div class="verification-popup">
                    <div class="popup-header">
                        <i class="fas fa-check-circle"></i>
                        <h3>Confirm Payment Details</h3>
                    </div>
                    <div class="popup-body">
                        <div class="detail-row">
                            <span class="detail-label">Amount:</span>
                            <span class="detail-value">₹${ramt}</span>
                        </div>
                        <div class="detail-row">
                            <span class="detail-label">UTR Number:</span>
                            <span class="detail-value">${refNo}</span>
                        </div>
                        <div class="detail-row">
                            <span class="detail-label">UPI ID:</span>
                            <span class="detail-value">${upi}</span>
                        </div>
                        <p class="popup-note">Please verify all details before proceeding</p>
                    </div>
                    <div class="popup-footer">
                        <button class="popup-btn cancel-btn">Cancel</button>
                        <button class="popup-btn confirm-btn">Confirm</button>
                    </div>
                </div>
            </div>
            `);
            
            $('body').append(popup);
            setTimeout(() => popup.addClass('active'), 10);
            
            popup.find('.cancel-btn').click(function() {
                popup.remove();
            });
            
            popup.find('.confirm-btn').click(function() {
                popup.remove();
                verifyPayment(refNo);
            });
        }
        
        // Verify payment function
        function verifyPayment(refNo) {
            $('#submit-btn').prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> Verifying...');
            $('#loading-overlay').addClass('active');
            countdownActive = false;
            
            // AJAX call to verify payment
            adddep(ramt, refNo, serial, upi, userId, token);
        }
        
        // Manual submit button click
        $('#submit-btn').click(function() {
            const refNo = $('#utr-input').val();
            if(refNo.length === 12) {
                showVerificationPopup(refNo);
            }
        });
        
        // UPI app buttons
        $('.upi-app').click(function() {
            const app = $(this).data('app');
            let url = '';
            const upiUrl = `upi://pay?pa=${encodeURIComponent(upi)}&pn=Recipient&am=${ramt}&cu=INR&tn=Payment`;
            
            switch(app) {
                case 'gpay': url = `https://gpay.app.goo.gl/${encodeURIComponent(upiUrl)}`; break;
                case 'phonepe': url = `phonepe://upi/pay?pa=${encodeURIComponent(upi)}&pn=Recipient&am=${ramt}&cu=INR`; break;
                case 'paytm': url = `paytmmp://upi/pay?pa=${encodeURIComponent(upi)}&pn=Recipient&am=${ramt}&cu=INR`; break;
                case 'bhim': url = `bhim://upi/pay?pa=${encodeURIComponent(upi)}&pn=Recipient&am=${ramt}&cu=INR`; break;
                default: url = upiUrl;
            }
            
            window.location.href = url;
            
            setTimeout(() => {
                if(!document.hidden) {
                    window.location.href = upiUrl;
                }
            }, 500);
        });
        
        // Payment verification function
        function adddep(amt, refnum, srl, upi, userId, token) {
            $.ajax({
                type: "POST",
                url: "adddeposit.php",
                data: {
                    amt: amt,
                    refnum: refnum,
                    srl: srl,
                    source: "wepay",
                    upi: upi,
                    userId: userId,
                    token: token
                },
                success: function(response) {
                    const arr = response.split('~');
                    
                    if (arr[0] == 1) {
                        $('#submit-btn').html('<i class="fas fa-check-circle"></i> Verified');
                        $('.payment-timer').html('<i class="fas fa-check-circle"></i> Verified');
                        $('#loading-overlay').removeClass('active');
                        
                        setTimeout(() => {
                            window.location.href = `depositconfirm.php?amt=${ramt}&refnum=${refnum}&srl=${serial}&userId=${userId}&token=${token}`;
                        }, 2000);
                    } else if(arr[0] == 0) {
                        alert("Error verifying payment");
                        $('#submit-btn').prop('disabled', false).html('<i class="fas fa-check-circle"></i> Verify Payment');
                        $('#loading-overlay').removeClass('active');
                        countdownActive = true;
                    } else if(arr[0] == 2) {
                        alert("Duplicate UTR number");
                        $('#submit-btn').prop('disabled', false).html('<i class="fas fa-check-circle"></i> Verify Payment');
                        $('#loading-overlay').removeClass('active');
                        countdownActive = true;
                    } else if(arr[0] == 3) {
                        alert("Please wait 1 minute before trying again");
                        $('#submit-btn').prop('disabled', false).html('<i class="fas fa-check-circle"></i> Verify Payment');
                        $('#loading-overlay').removeClass('active');
                        countdownActive = true;
                    } else if(arr[0] == 4) {
                        alert("Recharge option suspended\nContact Support");
                        $('#submit-btn').prop('disabled', true);
                        $('#loading-overlay').removeClass('active');
                    }
                },
                error: function() {
                    alert("Connection error. Please try again.");
                    $('#submit-btn').prop('disabled', false).html('<i class="fas fa-check-circle"></i> Verify Payment');
                    $('#loading-overlay').removeClass('active');
                    countdownActive = true;
                }
            });
        }
    });
    </script>
</body>
</html>
<?php
} else {
    header('Content-Type: application/json');
    echo json_encode(['code' => 400, 'success' => false, 'message' => 'Invalid request']);
}
?>